require "API/DST_API"
require "API/DST_Helpers"

local DST = rawget(_G, "DST") or {}
local ST  = DST and DST.SkillTooltips
if not ST then return end

local KEY = "Reloading"

ST.addContributor(KEY, function(ctx)
    local level = ctx.getLevel()

    -- Wiki: Aiming & Reloading XP gain is reduced at Level 5+ (~37% of normal)
    if level >= 5 then
        ctx.addHeader(ST.getText("IGUI_DST_Core_hdr"))
        ctx.add(ST.getText("IGUI_DST_Reloading_note_XP"))
    end
end)